/*
 * Copyright (C) 2023-2025 Intel Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef STATIC_GRAPH_READER_H
#define STATIC_GRAPH_READER_H

#include "StaticGraphBinaryAutogen.h"
#include "StaticGraphAutogen.h"

struct StaticReaderBinaryData {
    void* data = nullptr;
    uint32_t size = 0;
};

typedef enum {
    enPreview,
    enVideo,
    enStills,
    enRaw,
    enIr,
    enNumOfOutPins

} DataRangePins;

typedef struct DriverDesc {
    uint32_t format;
    uint32_t width;
    uint32_t height;
    uint32_t fps;

} DriverDesc;

typedef struct DataRangeHeader {
    uint32_t NumberOfPinResolutions[enNumOfOutPins];

} DataRangeHeader;

typedef struct {
    uint32_t key;
    uint32_t value;
} GraphHashCode;

typedef struct {
    uint32_t numOfGraphs;
    GraphHashCode* hashCodes;
} GraphHashCodesTable;

class StaticGraphReader {
 public:
    StaticGraphReader() = default;
    StaticGraphStatus Init(StaticReaderBinaryData& binaryGraphSettings);
    StaticGraphStatus GetStaticGraphConfig(GraphConfigurationKey& settingsKey,
                                           IStaticGraphConfig** graph);
    static const uint32_t staticGraphCommonHashCode = 361789904;  // autogenerated
 private:
    void GetSinkMappingConfiguration(GraphConfigurationHeader* baseGraphConfigurationHeader,
                                     VirtualSinkMapping* baseSinkMappingConfiguration,
                                     GraphConfigurationHeader* selectedGraphConfigurationHeader,
                                     VirtualSinkMapping* selectedSinkMappingConfiguration);
    BinaryHeader _binaryHeader;
    GraphConfigurationHeader* _graphConfigurationHeaders = nullptr;
    SensorMode* _sensorModes = nullptr;
    int8_t* _configurationData = nullptr;
    ZoomKeyResolutions _zoomKeyResolutions;
};

#endif